#include "../inc/QrfeHidBase.h"

HidReturnCode  QrfeHidBase::m_lastError = HID_DEVICE_SUCCESS;


QrfeHidBase::QrfeHidBase(QObject* parent)
	:QIODevice(parent)
{
	// Call a reset on the device data to initialize
	resetDeviceData();
}

QrfeHidBase::QrfeHidBase(QString devicePath, QObject* parent)
	:QIODevice(parent)
{
	m_devicePath = devicePath;

	// Call a reset on the device data to initialize
	resetDeviceData();
}

QrfeHidBase::~QrfeHidBase()
{
	m_readFifo.close();
	//close();
}

QString QrfeHidBase::devicePath() const
{
	return m_devicePath;
}

void QrfeHidBase::setDevicePath(QString devicePath)
{
	m_devicePath = devicePath;
}

quint8 QrfeHidBase::lastError()
{
	return m_lastError;
}

QString QrfeHidBase::errorString () const
{
	switch(lastError()){
	case HID_DEVICE_SUCCESS: 				return "Success";
	case HID_DEVICE_NOT_FOUND: 				return "Device not found";
	case HID_DEVICE_NOT_OPENED: 			return "Device not opened";
	case HID_DEVICE_ALREADY_OPENED: 		return "Device already opened";
	case HID_DEVICE_TRANSFER_TIMEOUT: 		return "Transfer timeout";
	case HID_DEVICE_TRANSFER_FAILED: 		return "Transfer failed";
	case HID_DEVICE_CANNOT_GET_HID_INFO: 	return "Cannot get HID info";
	case HID_DEVICE_HANDLE_ERROR: 			return "Handle error";
	case HID_DEVICE_INVALID_BUFFER_SIZE: 	return "Invalid buffer size";
	case HID_DEVICE_SYSTEM_CODE: 			return "System code";
	case HID_DEVICE_UNKNOWN_ERROR: 			return "Unknown error";
	default: 								return "Unknown error";
	}
}

void QrfeHidBase::resetDeviceData()
{
	// Set device opened to false
	m_deviceOpened = false;

	m_getReportTimeout = 0;
	m_setReportTimeout = 0;

	m_readFifo.open(QIODevice::ReadWrite);
}
